using System;
using System.Collections;
using System.ComponentModel;
using System.Data;

using System.Web.Services;
using System.DirectoryServices;
using System.Runtime.Remoting.Lifetime;

namespace AdResetter
{
	public class AdResetterObject : System.MarshalByRefObject
	{
		private readonly string objectName = "AdResetterObject";
		private string URI;
		private string Scope;
		private string user;
		private string password;

		public AdResetterObject()
		{
		}

		public bool Configure(string newURI, 
			string newScope,
			string newUser,
			string newPassword) 
		{
			this.URI = newURI;
			this.Scope = newScope;	
			this.user = newUser;
			this.password = newPassword;
			return VerifyADConnection();
		}

		public override object InitializeLifetimeService() 
		{
			return null;
		}

		public bool VerifyADConnection() 
		{
			try 
			{
				
				DirectoryEntry someEntry = new DirectoryEntry( "LDAP://" + this.URI + "/CN=Administrator," + this.Scope,this.user,this.password,System.DirectoryServices.AuthenticationTypes.SecureSocketsLayer);
				if (someEntry.Properties["cn"].Value.ToString() == "Administrator") 
				{
					return true;
				}				
			}
			catch (Exception e) 
			{
				LogObjectException(e);
			}
			return false;
		}

		//returns true if we succeed, false otherwise
		public bool ResetADPassword(string target, string newPassword) 
		{
			try 
			{
				if (VerifyADConnection()) 
				{
					DirectoryEntry userEntry = new DirectoryEntry( "LDAP://" + this.URI + "/" + target +"," + this.Scope,this.user,this.password,System.DirectoryServices.AuthenticationTypes.SecureSocketsLayer);
					if (userEntry != null) 
					{
						userEntry.Invoke("setPassword",newPassword);
						if (!userEntry.Properties["lockoutTime"].Value.Equals("0")) 
						{
							userEntry.Properties["lockoutTime"].Value = 0;
						}
						userEntry.CommitChanges();
					}  
					return true;
				} 
				else 
				{
					return false;
				}
			}
			catch (Exception e) 
			{
				return false;
			}
		}

		// Call this method for a common exception handler for the object if desired.
		private void LogObjectException(Exception ex)
		{
			//
			// Throw a new Exception with the object name in the message, which will trigger an error
			// and if called from a servic, an event in the Windows Event Log under the Application container.
			throw new Exception(this.objectName + " :: Exception: " + ex.Message, ex);
		}
	}
}
