using System;
using System.Runtime.Remoting; 
using System.Runtime.Remoting.Channels;
using System.Runtime.Remoting.Channels.Tcp;
using AdResetter;

namespace AdResetter
{
	class AdResetterTestClient
	{ 
		static void Main(string[] args) 
		{ 
			TcpChannel chan = new TcpChannel();
			ChannelServices.RegisterChannel(chan);
			AdResetterObject adro = (AdResetterObject)Activator.GetObject(
				typeof(AdResetterObject),
				"tcp://localhost:8085/AdResetterService"); 
			if (adro == null) 
			{
				Console.WriteLine("cannot locate server");
			} 
			else 
			{	
				if (adro.VerifyADConnection()) 
				{
					Console.WriteLine("verified server connection");
					if (adro.ResetADPassword("CN=Test Test","somep@$$w0rd2")) 
					{
						Console.WriteLine("successfully reset test user password");
					} 
					else 
					{
						Console.WriteLine("could not reset test user password");
					}
					if (adro.ResetADPassword("Test Test","poop")) 
					{
						Console.WriteLine("successfully reset test user password to a bad password");
					} 
					else 
					{
						Console.WriteLine("could not reset test user password to a bad password");
					}
				}
			}
			return;
		} 
	} 
}