using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.ServiceProcess;
using System.Configuration;
using System.Runtime.Remoting;
using System.Runtime.Remoting.Channels;
using System.Runtime.Remoting.Channels.Tcp;


namespace AdResetter
{
	public class AdResetterService : System.ServiceProcess.ServiceBase
	{
		/// <summary> 
		/// Required designer variable.
		/// </summary>
		private int tcpPort = 8085;
		private static readonly string _serviceName = "AdResetterService";
		private System.ComponentModel.Container components = null;

		public AdResetterService() 
		{
			InitializeComponent();
		}

		// The main entry point for the process
		static void Main(string[] args)
		{
			try
			{
				System.ServiceProcess.ServiceBase[] ServicesToRun;
				ServicesToRun = new System.ServiceProcess.ServiceBase[] { new AdResetterService() };
				System.ServiceProcess.ServiceBase.Run(ServicesToRun);
			}
			catch (Exception e) 
			{
				LogServiceException(e);
			}
		}

		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			components = new System.ComponentModel.Container();
			this.ServiceName = _serviceName;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		/// <summary>
		/// Set things in motion so your service can do its work.
		/// </summary>
		protected override void OnStart(string[] args)
		{
			try
			{
                TcpChannel channel = new TcpChannel(this.tcpPort);
				ChannelServices.RegisterChannel(channel);
				RemotingConfiguration.RegisterWellKnownServiceType(
					typeof(AdResetterObject),
					"AdResetterService",
					WellKnownObjectMode.Singleton);	
				loadConfig();
			}
			catch (Exception e)
			{
				LogServiceException(e);
			}
		}
 
		/// <summary>
		/// Stop this service.
		/// </summary>
		protected override void OnStop()
		{
			try
			{
			}
			catch (Exception e)
			{
				LogServiceException(e);
			}
		}

		private static void LogServiceException(Exception ex)
		{
			// Throw a new ServerException with the Service name in the message, which will trigger an error
			// event in the Windows Event Log under the Application container.
			throw new ServerException(_serviceName + " :: Exception: " + ex.Message, ex);
		}

		private void loadConfig() 
		{			
			string configURI = System.Configuration.ConfigurationSettings.AppSettings["server"];
			string configScope = System.Configuration.ConfigurationSettings.AppSettings["scope"];
			string configUser = System.Configuration.ConfigurationSettings.AppSettings["user"];
			string configPassword = System.Configuration.ConfigurationSettings.AppSettings["password"];

			AdResetterObject adro = (AdResetterObject)Activator.GetObject(
				typeof(AdResetterObject),
				"tcp://localhost:8085/AdResetterService"); 
			if (!adro.Configure(configURI,configScope,configUser,configPassword)) 
			{
				throw new ServerException(_serviceName + " :: Exception: Could not configure with: " + configURI + ":" + configScope + ":" + configUser + ":" + configPassword);
			}
		}
	}
}
